﻿using Microsoft.Xrm.Sdk;
using System;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Runtime.Serialization.Json;
using System.Text;
using VA.PPMS.CRM.Plugins.Data;

namespace VA.PPMS.CRM.Plugins.Helper
{
    public static class GeocodeHelper
    {
        public const string ConfidenceHigh = "High";
        private const string BingMapsKey = "Av5A7yAWKLOF6lCCjOLl0I4tUh5b6ZP9c25PHmLrQF9zJGpW7lnYPAvm1Odo52VV";

        public static PpmsCoordinate Geocode(string address)
        {
            var url = new Uri(string.Format("http://dev.virtualearth.net/REST/v1/Locations?query={0}&key={1}", Uri.EscapeDataString(address), BingMapsKey));

            using (var httpClient = new HttpClient())
            {
                var response = httpClient.GetStringAsync(url).GetAwaiter().GetResult();
                var bingResponse = Deserialize<Response>(response);

                var resourceSet = bingResponse.ResourceSets.FirstOrDefault();
                if (resourceSet == null) return GetNotFoundCoordinates("Unable to parse Bing Maps Response. The Resource Set element is missing.");

                var resource = resourceSet.Resources.FirstOrDefault();
                if (resource == null) return GetNotFoundCoordinates("Unable to parse Bing Maps Response. The Resource element is missing.");

                var location = resource as Location;
                if (location == null) return GetNotFoundCoordinates("Unable to parse Bing Maps Response. The Resource element does not map to a Location object.");

                if (location.Point == null || location.Point.Coordinates == null || location.Point.Coordinates.Length < 2) return GetNotFoundCoordinates("Unable to parse Bing Maps Response. The Location doesn't have any coordinates");
                
                return new PpmsCoordinate
                {
                    Latitude = location.Point.Coordinates[0],
                    Longitude = location.Point.Coordinates[1],
                    //ConfidenceScore = location.Confidence
                };
            }
        }

        private static T Deserialize<T>(string payload)
        {
            var serializer = new DataContractJsonSerializer(typeof(T));

            using (var stream = new MemoryStream(Encoding.UTF8.GetBytes(payload)))
            {
                return (T)serializer.ReadObject(stream);
            }
        }

        private static PpmsCoordinate GetNotFoundCoordinates(string message)
        {
            return new PpmsCoordinate
            {
                Latitude = 0,
                Longitude = 0,
                //Confidence = message
            };
        }
    }

    public class PpmsCoordinate
    {
        public PpmsCoordinate() {}

        public PpmsCoordinate(double latitude, double longitude)
        {
            Latitude = latitude;
            Longitude = longitude;
        }

        public PpmsCoordinate(double latitude, double longitude, int confidencescore)
            : this(latitude, longitude)
        {
            ConfidenceScore = confidencescore;
        }

        public double Latitude { get; set; }

        public double Longitude { get; set; }

        public int ConfidenceScore { get; set; }
    }
}